library(ComplexUpset)
library(UpSetR)

expressionInput <- c(
  "cerebellum"=303,
  "cerebrum"=409,
  "heart"=573,
  "kidney"=510,
  "liver"=568,
  "lung"=526,
  "pancreas"=490,
  "pbmcHealthy"=452,
  "spleen"=562,
  "thymus"=463,
  "cerebellum&cerebrum"=155,
  "cerebellum&heart"=80,
  "cerebellum&kidney"=117,
  "cerebellum&liver"=39,
  "cerebellum&lung"=36,
  "cerebellum&pancreas"=54,
  "cerebellum&pbmcHealthy"=12,
  "cerebellum&spleen"=102,
  "cerebellum&thymus"=100,
  "cerebrum&heart"=177,
  "cerebrum&kidney"=154,
  "cerebrum&liver"=94,
  "cerebrum&lung"=106,
  "cerebrum&pancreas"=76,
  "cerebrum&pbmcHealthy"=82,
  "cerebrum&spleen"=74,
  "cerebrum&thymus"=99,
  "heart&kidney"=211,
  "heart&liver"=254,
  "heart&lung"=242,
  "heart&pancreas"=126,
  "heart&pbmcHealthy"=229,
  "heart&spleen"=268,
  "heart&thymus"=187,
  "kidney&liver"=121,
  "kidney&lung"=229,
  "kidney&pancreas"=126,
  "kidney&pbmcHealthy"=35,
  "kidney&spleen"=114,
  "kidney&thymus"=125,
  "liver&lung"=219,
  "liver&pancreas"=102,
  "liver&pbmcHealthy"=360,
  "liver&spleen"=538,
  "liver&thymus"=239,
  "lung&pancreas"=57,
  "lung&pbmcHealthy"=171,
  "lung&spleen"=231,
  "lung&thymus"=187,
  "pancreas&pbmcHealthy"=15,
  "pancreas&spleen"=91,
  "pancreas&thymus"=112,
  "pbmcHealthy&spleen"=373,
  "pbmcHealthy&thymus"=140,
  "spleen&thymus"=212,
  "cerebellum&cerebrum&heart"=33,
  "cerebellum&cerebrum&kidney"=42,
  "cerebellum&cerebrum&liver"=21,
  "cerebellum&cerebrum&lung"=32,
  "cerebellum&cerebrum&pancreas"=24,
  "cerebellum&cerebrum&pbmcHealthy"=11,
  "cerebellum&cerebrum&spleen"=24,
  "cerebellum&cerebrum&thymus"=42,
  "cerebellum&heart&kidney"=49,
  "cerebellum&heart&liver"=20,
  "cerebellum&heart&lung"=19,
  "cerebellum&heart&pancreas"=27,
  "cerebellum&heart&spleen"=47,
  "cerebellum&heart&thymus"=47,
  "cerebellum&kidney&liver"=26,
  "cerebellum&kidney&lung"=32,
  "cerebellum&kidney&pancreas"=45,
  "cerebellum&kidney&pbmcHealthy"=11,
  "cerebellum&kidney&spleen"=55,
  "cerebellum&kidney&thymus"=67,
  "cerebellum&liver&lung"=20,
  "cerebellum&liver&pancreas"=24,
  "cerebellum&liver&pbmcHealthy"=1,
  "cerebellum&liver&spleen"=26,
  "cerebellum&liver&thymus"=30,
  "cerebellum&lung&pancreas"=19,
  "cerebellum&lung&pbmcHealthy"=9,
  "cerebellum&lung&spleen"=19,
  "cerebellum&lung&thymus"=28,
  "cerebellum&pancreas&pbmcHealthy"=1,
  "cerebellum&pancreas&spleen"=43,
  "cerebellum&pancreas&thymus"=43,
  "cerebellum&pbmcHealthy&thymus"=11,
  "cerebellum&spleen&thymus"=55,
  "cerebrum&heart&kidney"=105,
  "cerebrum&heart&liver"=73,
  "cerebrum&heart&lung"=87,
  "cerebrum&heart&pancreas"=53,
  "cerebrum&heart&pbmcHealthy"=24,
  "cerebrum&heart&spleen"=44,
  "cerebrum&heart&thymus"=43,
  "cerebrum&kidney&liver"=60,
  "cerebrum&kidney&lung"=87,
  "cerebrum&kidney&pancreas"=52,
  "cerebrum&kidney&pbmcHealthy"=10,
  "cerebrum&kidney&spleen"=31,
  "cerebrum&kidney&thymus"=66,
  "cerebrum&liver&lung"=50,
  "cerebrum&liver&pancreas"=43,
  "cerebrum&liver&pbmcHealthy"=37,
  "cerebrum&liver&spleen"=50,
  "cerebrum&liver&thymus"=26,
  "cerebrum&lung&pancreas"=34,
  "cerebrum&lung&pbmcHealthy"=28,
  "cerebrum&lung&spleen"=37,
  "cerebrum&lung&thymus"=54,
  "cerebrum&pancreas&pbmcHealthy"=6,
  "cerebrum&pancreas&spleen"=23,
  "cerebrum&pancreas&thymus"=35,
  "cerebrum&pbmcHealthy&spleen"=43,
  "cerebrum&pbmcHealthy&thymus"=10,
  "cerebrum&spleen&thymus"=22,
  "heart&kidney&liver"=91,
  "heart&kidney&lung"=111,
  "heart&kidney&pancreas"=89,
  "heart&kidney&pbmcHealthy"=23,
  "heart&kidney&spleen"=75,
  "heart&kidney&thymus"=71,
  "heart&liver&lung"=159,
  "heart&liver&pancreas"=56,
  "heart&liver&pbmcHealthy"=174,
  "heart&liver&spleen"=224,
  "heart&liver&thymus"=134,
  "heart&lung&pancreas"=35,
  "heart&lung&pbmcHealthy"=112,
  "heart&lung&spleen"=152,
  "heart&lung&thymus"=114,
  "heart&pancreas&pbmcHealthy"=4,
  "heart&pancreas&spleen"=37,
  "heart&pancreas&thymus"=51,
  "heart&pbmcHealthy&spleen"=200,
  "heart&pbmcHealthy&thymus"=105,
  "heart&spleen&thymus"=141,
  "kidney&liver&lung"=71,
  "kidney&liver&pancreas"=59,
  "kidney&liver&pbmcHealthy"=24,
  "kidney&liver&spleen"=53,
  "kidney&liver&thymus"=49,
  "kidney&lung&pancreas"=40,
  "kidney&lung&pbmcHealthy"=28,
  "kidney&lung&spleen"=49,
  "kidney&lung&thymus"=72,
  "kidney&pancreas&pbmcHealthy"=2,
  "kidney&pancreas&spleen"=63,
  "kidney&pancreas&thymus"=57,
  "kidney&pbmcHealthy&spleen"=23,
  "kidney&pbmcHealthy&thymus"=31,
  "kidney&spleen&thymus"=62,
  "liver&lung&pancreas"=33,
  "liver&lung&pbmcHealthy"=159,
  "liver&lung&spleen"=209,
  "liver&lung&thymus"=121,
  "liver&pancreas&pbmcHealthy"=14,
  "liver&pancreas&spleen"=50,
  "liver&pancreas&thymus"=48,
  "liver&pbmcHealthy&spleen"=354,
  "liver&pbmcHealthy&thymus"=125,
  "liver&spleen&thymus"=179,
  "lung&pancreas&pbmcHealthy"=5,
  "lung&pancreas&spleen"=25,
  "lung&pancreas&thymus"=31,
  "lung&pbmcHealthy&spleen"=158,
  "lung&pbmcHealthy&thymus"=92,
  "lung&spleen&thymus"=115,
  "pancreas&pbmcHealthy&spleen"=14,
  "pancreas&pbmcHealthy&thymus"=3,
  "pancreas&spleen&thymus"=56,
  "pbmcHealthy&spleen&thymus"=121,
  "cerebellum&cerebrum&heart&kidney"=18,
  "cerebellum&cerebrum&heart&liver"=15,
  "cerebellum&cerebrum&heart&lung"=18,
  "cerebellum&cerebrum&heart&pancreas"=13,
  "cerebellum&cerebrum&heart&spleen"=17,
  "cerebellum&cerebrum&heart&thymus"=14,
  "cerebellum&cerebrum&kidney&liver"=20,
  "cerebellum&cerebrum&kidney&lung"=32,
  "cerebellum&cerebrum&kidney&pancreas"=24,
  "cerebellum&cerebrum&kidney&pbmcHealthy"=10,
  "cerebellum&cerebrum&kidney&spleen"=21,
  "cerebellum&cerebrum&kidney&thymus"=37,
  "cerebellum&cerebrum&liver&lung"=20,
  "cerebellum&cerebrum&liver&pancreas"=18,
  "cerebellum&cerebrum&liver&spleen"=16,
  "cerebellum&cerebrum&liver&thymus"=17,
  "cerebellum&cerebrum&lung&pancreas"=19,
  "cerebellum&cerebrum&lung&pbmcHealthy"=9,
  "cerebellum&cerebrum&lung&spleen"=19,
  "cerebellum&cerebrum&lung&thymus"=27,
  "cerebellum&cerebrum&pancreas&spleen"=16,
  "cerebellum&cerebrum&pancreas&thymus"=23,
  "cerebellum&cerebrum&pbmcHealthy&thymus"=10,
  "cerebellum&cerebrum&spleen&thymus"=18,
  "cerebellum&heart&kidney&liver"=17,
  "cerebellum&heart&kidney&lung"=18,
  "cerebellum&heart&kidney&pancreas"=26,
  "cerebellum&heart&kidney&spleen"=36,
  "cerebellum&heart&kidney&thymus"=34,
  "cerebellum&heart&liver&lung"=14,
  "cerebellum&heart&liver&pancreas"=13,
  "cerebellum&heart&liver&spleen"=12,
  "cerebellum&heart&liver&thymus"=15,
  "cerebellum&heart&lung&pancreas"=13,
  "cerebellum&heart&lung&spleen"=13,
  "cerebellum&heart&lung&thymus"=13,
  "cerebellum&heart&pancreas&spleen"=23,
  "cerebellum&heart&pancreas&thymus"=23,
  "cerebellum&heart&spleen&thymus"=31,
  "cerebellum&kidney&liver&lung"=20,
  "cerebellum&kidney&liver&pancreas"=20,
  "cerebellum&kidney&liver&pbmcHealthy"=1,
  "cerebellum&kidney&liver&spleen"=19,
  "cerebellum&kidney&liver&thymus"=23,
  "cerebellum&kidney&lung&pancreas"=19,
  "cerebellum&kidney&lung&pbmcHealthy"=9,
  "cerebellum&kidney&lung&spleen"=19,
  "cerebellum&kidney&lung&thymus"=27,
  "cerebellum&kidney&pancreas&pbmcHealthy"=1,
  "cerebellum&kidney&pancreas&spleen"=36,
  "cerebellum&kidney&pancreas&thymus"=39,
  "cerebellum&kidney&pbmcHealthy&thymus"=11,
  "cerebellum&kidney&spleen&thymus"=38,
  "cerebellum&liver&lung&pancreas"=18,
  "cerebellum&liver&lung&spleen"=15,
  "cerebellum&liver&lung&thymus"=17,
  "cerebellum&liver&pancreas&pbmcHealthy"=1,
  "cerebellum&liver&pancreas&spleen"=18,
  "cerebellum&liver&pancreas&thymus"=21,
  "cerebellum&liver&pbmcHealthy&thymus"=1,
  "cerebellum&liver&spleen&thymus"=23,
  "cerebellum&lung&pancreas&spleen"=15,
  "cerebellum&lung&pancreas&thymus"=18,
  "cerebellum&lung&pbmcHealthy&thymus"=9,
  "cerebellum&lung&spleen&thymus"=16,
  "cerebellum&pancreas&pbmcHealthy&thymus"=1,
  "cerebellum&pancreas&spleen&thymus"=35,
  "cerebrum&heart&kidney&liver"=49,
  "cerebrum&heart&kidney&lung"=67,
  "cerebrum&heart&kidney&pancreas"=41,
  "cerebrum&heart&kidney&spleen"=24,
  "cerebrum&heart&kidney&thymus"=32,
  "cerebrum&heart&liver&lung"=45,
  "cerebrum&heart&liver&pancreas"=35,
  "cerebrum&heart&liver&pbmcHealthy"=22,
  "cerebrum&heart&liver&spleen"=34,
  "cerebrum&heart&liver&thymus"=17,
  "cerebrum&heart&lung&pancreas"=25,
  "cerebrum&heart&lung&pbmcHealthy"=19,
  "cerebrum&heart&lung&spleen"=35,
  "cerebrum&heart&lung&thymus"=30,
  "cerebrum&heart&pancreas&spleen"=13,
  "cerebrum&heart&pancreas&thymus"=23,
  "cerebrum&heart&pbmcHealthy&spleen"=22,
  "cerebrum&heart&spleen&thymus"=14,
  "cerebrum&kidney&liver&lung"=42,
  "cerebrum&kidney&liver&pancreas"=37,
  "cerebrum&kidney&liver&spleen"=24,
  "cerebrum&kidney&liver&thymus"=24,
  "cerebrum&kidney&lung&pancreas"=29,
  "cerebrum&kidney&lung&pbmcHealthy"=9,
  "cerebrum&kidney&lung&spleen"=27,
  "cerebrum&kidney&lung&thymus"=41,
  "cerebrum&kidney&pancreas&spleen"=21,
  "cerebrum&kidney&pancreas&thymus"=33,
  "cerebrum&kidney&pbmcHealthy&thymus"=10,
  "cerebrum&kidney&spleen&thymus"=21,
  "cerebrum&liver&lung&pancreas"=26,
  "cerebrum&liver&lung&pbmcHealthy"=20,
  "cerebrum&liver&lung&spleen"=32,
  "cerebrum&liver&lung&thymus"=24,
  "cerebrum&liver&pancreas&pbmcHealthy"=5,
  "cerebrum&liver&pancreas&spleen"=20,
  "cerebrum&liver&pancreas&thymus"=20,
  "cerebrum&liver&pbmcHealthy&spleen"=37,
  "cerebrum&liver&spleen&thymus"=17,
  "cerebrum&lung&pancreas&spleen"=20,
  "cerebrum&lung&pancreas&thymus"=22,
  "cerebrum&lung&pbmcHealthy&spleen"=20,
  "cerebrum&lung&pbmcHealthy&thymus"=9,
  "cerebrum&lung&spleen&thymus"=19,
  "cerebrum&pancreas&pbmcHealthy&spleen"=6,
  "cerebrum&pancreas&spleen&thymus"=17,
  "heart&kidney&liver&lung"=55,
  "heart&kidney&liver&pancreas"=45,
  "heart&kidney&liver&pbmcHealthy"=22,
  "heart&kidney&liver&spleen"=44,
  "heart&kidney&liver&thymus"=36,
  "heart&kidney&lung&pancreas"=27,
  "heart&kidney&lung&pbmcHealthy"=18,
  "heart&kidney&lung&spleen"=36,
  "heart&kidney&lung&thymus"=39,
  "heart&kidney&pancreas&pbmcHealthy"=1,
  "heart&kidney&pancreas&spleen"=34,
  "heart&kidney&pancreas&thymus"=37,
  "heart&kidney&pbmcHealthy&spleen"=22,
  "heart&kidney&pbmcHealthy&thymus"=19,
  "heart&kidney&spleen&thymus"=44,
  "heart&liver&lung&pancreas"=22,
  "heart&liver&lung&pbmcHealthy"=109,
  "heart&liver&lung&spleen"=148,
  "heart&liver&lung&thymus"=103,
  "heart&liver&pancreas&pbmcHealthy"=4,
  "heart&liver&pancreas&spleen"=23,
  "heart&liver&pancreas&thymus"=23,
  "heart&liver&pbmcHealthy&spleen"=172,
  "heart&liver&pbmcHealthy&thymus"=103,
  "heart&liver&spleen&thymus"=127,
  "heart&lung&pancreas&pbmcHealthy"=1,
  "heart&lung&pancreas&spleen"=15,
  "heart&lung&pancreas&thymus"=19,
  "heart&lung&pbmcHealthy&spleen"=109,
  "heart&lung&pbmcHealthy&thymus"=76,
  "heart&lung&spleen&thymus"=102,
  "heart&pancreas&pbmcHealthy&spleen"=4,
  "heart&pancreas&pbmcHealthy&thymus"=2,
  "heart&pancreas&spleen&thymus"=26,
  "heart&pbmcHealthy&spleen&thymus"=102,
  "kidney&liver&lung&pancreas"=30,
  "kidney&liver&lung&pbmcHealthy"=19,
  "kidney&liver&lung&spleen"=40,
  "kidney&liver&lung&thymus"=42,
  "kidney&liver&pancreas&pbmcHealthy"=2,
  "kidney&liver&pancreas&spleen"=29,
  "kidney&liver&pancreas&thymus"=24,
  "kidney&liver&pbmcHealthy&spleen"=23,
  "kidney&liver&pbmcHealthy&thymus"=20,
  "kidney&liver&spleen&thymus"=37,
  "kidney&lung&pancreas&spleen"=21,
  "kidney&lung&pancreas&thymus"=26,
  "kidney&lung&pbmcHealthy&spleen"=18,
  "kidney&lung&pbmcHealthy&thymus"=26,
  "kidney&lung&spleen&thymus"=31,
  "kidney&pancreas&pbmcHealthy&spleen"=1,
  "kidney&pancreas&pbmcHealthy&thymus"=2,
  "kidney&pancreas&spleen&thymus"=40,
  "kidney&pbmcHealthy&spleen&thymus"=19,
  "liver&lung&pancreas&pbmcHealthy"=5,
  "liver&lung&pancreas&spleen"=23,
  "liver&lung&pancreas&thymus"=21,
  "liver&lung&pbmcHealthy&spleen"=158,
  "liver&lung&pbmcHealthy&thymus"=81,
  "liver&lung&spleen&thymus"=112,
  "liver&pancreas&pbmcHealthy&spleen"=13,
  "liver&pancreas&pbmcHealthy&thymus"=3,
  "liver&pancreas&spleen&thymus"=31,
  "liver&pbmcHealthy&spleen&thymus"=119,
  "lung&pancreas&pbmcHealthy&spleen"=5,
  "lung&pancreas&spleen&thymus"=18,
  "lung&pbmcHealthy&spleen&thymus"=81,
  "pancreas&pbmcHealthy&spleen&thymus"=2,
  "cerebellum&cerebrum&heart&kidney&liver"=14,
  "cerebellum&cerebrum&heart&kidney&lung"=18,
  "cerebellum&cerebrum&heart&kidney&pancreas"=13,
  "cerebellum&cerebrum&heart&kidney&spleen"=14,
  "cerebellum&cerebrum&heart&kidney&thymus"=13,
  "cerebellum&cerebrum&heart&liver&lung"=14,
  "cerebellum&cerebrum&heart&liver&pancreas"=12,
  "cerebellum&cerebrum&heart&liver&spleen"=10,
  "cerebellum&cerebrum&heart&liver&thymus"=11,
  "cerebellum&cerebrum&heart&lung&pancreas"=13,
  "cerebellum&cerebrum&heart&lung&spleen"=13,
  "cerebellum&cerebrum&heart&lung&thymus"=13,
  "cerebellum&cerebrum&heart&pancreas&spleen"=9,
  "cerebellum&cerebrum&heart&pancreas&thymus"=12,
  "cerebellum&cerebrum&heart&spleen&thymus"=11,
  "cerebellum&cerebrum&kidney&liver&lung"=20,
  "cerebellum&cerebrum&kidney&liver&pancreas"=18,
  "cerebellum&cerebrum&kidney&liver&spleen"=16,
  "cerebellum&cerebrum&kidney&liver&thymus"=17,
  "cerebellum&cerebrum&kidney&lung&pancreas"=19,
  "cerebellum&cerebrum&kidney&lung&pbmcHealthy"=9,
  "cerebellum&cerebrum&kidney&lung&spleen"=19,
  "cerebellum&cerebrum&kidney&lung&thymus"=27,
  "cerebellum&cerebrum&kidney&pancreas&spleen"=16,
  "cerebellum&cerebrum&kidney&pancreas&thymus"=23,
  "cerebellum&cerebrum&kidney&pbmcHealthy&thymus"=10,
  "cerebellum&cerebrum&kidney&spleen&thymus"=18,
  "cerebellum&cerebrum&liver&lung&pancreas"=18,
  "cerebellum&cerebrum&liver&lung&spleen"=15,
  "cerebellum&cerebrum&liver&lung&thymus"=17,
  "cerebellum&cerebrum&liver&pancreas&spleen"=14,
  "cerebellum&cerebrum&liver&pancreas&thymus"=17,
  "cerebellum&cerebrum&liver&spleen&thymus"=15,
  "cerebellum&cerebrum&lung&pancreas&spleen"=15,
  "cerebellum&cerebrum&lung&pancreas&thymus"=18,
  "cerebellum&cerebrum&lung&pbmcHealthy&thymus"=9,
  "cerebellum&cerebrum&lung&spleen&thymus"=16,
  "cerebellum&cerebrum&pancreas&spleen&thymus"=16,
  "cerebellum&heart&kidney&liver&lung"=14,
  "cerebellum&heart&kidney&liver&pancreas"=13,
  "cerebellum&heart&kidney&liver&spleen"=12,
  "cerebellum&heart&kidney&liver&thymus"=14,
  "cerebellum&heart&kidney&lung&pancreas"=13,
  "cerebellum&heart&kidney&lung&spleen"=13,
  "cerebellum&heart&kidney&lung&thymus"=13,
  "cerebellum&heart&kidney&pancreas&spleen"=23,
  "cerebellum&heart&kidney&pancreas&thymus"=23,
  "cerebellum&heart&kidney&spleen&thymus"=26,
  "cerebellum&heart&liver&lung&pancreas"=12,
  "cerebellum&heart&liver&lung&spleen"=9,
  "cerebellum&heart&liver&lung&thymus"=11,
  "cerebellum&heart&liver&pancreas&spleen"=9,
  "cerebellum&heart&liver&pancreas&thymus"=12,
  "cerebellum&heart&liver&spleen&thymus"=11,
  "cerebellum&heart&lung&pancreas&spleen"=9,
  "cerebellum&heart&lung&pancreas&thymus"=12,
  "cerebellum&heart&lung&spleen&thymus"=10,
  "cerebellum&heart&pancreas&spleen&thymus"=21,
  "cerebellum&kidney&liver&lung&pancreas"=18,
  "cerebellum&kidney&liver&lung&spleen"=15,
  "cerebellum&kidney&liver&lung&thymus"=17,
  "cerebellum&kidney&liver&pancreas&pbmcHealthy"=1,
  "cerebellum&kidney&liver&pancreas&spleen"=15,
  "cerebellum&kidney&liver&pancreas&thymus"=19,
  "cerebellum&kidney&liver&pbmcHealthy&thymus"=1,
  "cerebellum&kidney&liver&spleen&thymus"=18,
  "cerebellum&kidney&lung&pancreas&spleen"=15,
  "cerebellum&kidney&lung&pancreas&thymus"=18,
  "cerebellum&kidney&lung&pbmcHealthy&thymus"=9,
  "cerebellum&kidney&lung&spleen&thymus"=16,
  "cerebellum&kidney&pancreas&pbmcHealthy&thymus"=1,
  "cerebellum&kidney&pancreas&spleen&thymus"=31,
  "cerebellum&liver&lung&pancreas&spleen"=14,
  "cerebellum&liver&lung&pancreas&thymus"=17,
  "cerebellum&liver&lung&spleen&thymus"=14,
  "cerebellum&liver&pancreas&pbmcHealthy&thymus"=1,
  "cerebellum&liver&pancreas&spleen&thymus"=16,
  "cerebellum&lung&pancreas&spleen&thymus"=15,
  "cerebrum&heart&kidney&liver&lung"=32,
  "cerebrum&heart&kidney&liver&pancreas"=30,
  "cerebrum&heart&kidney&liver&spleen"=17,
  "cerebrum&heart&kidney&liver&thymus"=15,
  "cerebrum&heart&kidney&lung&pancreas"=21,
  "cerebrum&heart&kidney&lung&spleen"=20,
  "cerebrum&heart&kidney&lung&thymus"=23,
  "cerebrum&heart&kidney&pancreas&spleen"=13,
  "cerebrum&heart&kidney&pancreas&thymus"=22,
  "cerebrum&heart&kidney&spleen&thymus"=13,
  "cerebrum&heart&liver&lung&pancreas"=19,
  "cerebrum&heart&liver&lung&pbmcHealthy"=19,
  "cerebrum&heart&liver&lung&spleen"=30,
  "cerebrum&heart&liver&lung&thymus"=15,
  "cerebrum&heart&liver&pancreas&spleen"=12,
  "cerebrum&heart&liver&pancreas&thymus"=14,
  "cerebrum&heart&liver&pbmcHealthy&spleen"=22,
  "cerebrum&heart&liver&spleen&thymus"=11,
  "cerebrum&heart&lung&pancreas&spleen"=13,
  "cerebrum&heart&lung&pancreas&thymus"=15,
  "cerebrum&heart&lung&pbmcHealthy&spleen"=19,
  "cerebrum&heart&lung&spleen&thymus"=13,
  "cerebrum&heart&pancreas&spleen&thymus"=10,
  "cerebrum&kidney&liver&lung&pancreas"=26,
  "cerebrum&kidney&liver&lung&spleen"=23,
  "cerebrum&kidney&liver&lung&thymus"=24,
  "cerebrum&kidney&liver&pancreas&spleen"=19,
  "cerebrum&kidney&liver&pancreas&thymus"=19,
  "cerebrum&kidney&liver&spleen&thymus"=17,
  "cerebrum&kidney&lung&pancreas&spleen"=20,
  "cerebrum&kidney&lung&pancreas&thymus"=21,
  "cerebrum&kidney&lung&pbmcHealthy&thymus"=9,
  "cerebrum&kidney&lung&spleen&thymus"=18,
  "cerebrum&kidney&pancreas&spleen&thymus"=17,
  "cerebrum&liver&lung&pancreas&spleen"=19,
  "cerebrum&liver&lung&pancreas&thymus"=19,
  "cerebrum&liver&lung&pbmcHealthy&spleen"=20,
  "cerebrum&liver&lung&spleen&thymus"=16,
  "cerebrum&liver&pancreas&pbmcHealthy&spleen"=5,
  "cerebrum&liver&pancreas&spleen&thymus"=15,
  "cerebrum&lung&pancreas&spleen&thymus"=16,
  "heart&kidney&liver&lung&pancreas"=22,
  "heart&kidney&liver&lung&pbmcHealthy"=18,
  "heart&kidney&liver&lung&spleen"=32,
  "heart&kidney&liver&lung&thymus"=29,
  "heart&kidney&liver&pancreas&pbmcHealthy"=1,
  "heart&kidney&liver&pancreas&spleen"=20,
  "heart&kidney&liver&pancreas&thymus"=16,
  "heart&kidney&liver&pbmcHealthy&spleen"=22,
  "heart&kidney&liver&pbmcHealthy&thymus"=19,
  "heart&kidney&liver&spleen&thymus"=29,
  "heart&kidney&lung&pancreas&spleen"=14,
  "heart&kidney&lung&pancreas&thymus"=17,
  "heart&kidney&lung&pbmcHealthy&spleen"=18,
  "heart&kidney&lung&pbmcHealthy&thymus"=15,
  "heart&kidney&lung&spleen&thymus"=23,
  "heart&kidney&pancreas&pbmcHealthy&spleen"=1,
  "heart&kidney&pancreas&pbmcHealthy&thymus"=1,
  "heart&kidney&pancreas&spleen&thymus"=24,
  "heart&kidney&pbmcHealthy&spleen&thymus"=19,
  "heart&liver&lung&pancreas&pbmcHealthy"=1,
  "heart&liver&lung&pancreas&spleen"=13,
  "heart&liver&lung&pancreas&thymus"=14,
  "heart&liver&lung&pbmcHealthy&spleen"=109,
  "heart&liver&lung&pbmcHealthy&thymus"=76,
  "heart&liver&lung&spleen&thymus"=100,
  "heart&liver&pancreas&pbmcHealthy&spleen"=4,
  "heart&liver&pancreas&pbmcHealthy&thymus"=2,
  "heart&liver&pancreas&spleen&thymus"=13,
  "heart&liver&pbmcHealthy&spleen&thymus"=100,
  "heart&lung&pancreas&pbmcHealthy&spleen"=1,
  "heart&lung&pancreas&spleen&thymus"=11,
  "heart&lung&pbmcHealthy&spleen&thymus"=76,
  "heart&pancreas&pbmcHealthy&spleen&thymus"=2,
  "kidney&liver&lung&pancreas&spleen"=19,
  "kidney&liver&lung&pancreas&thymus"=20,
  "kidney&liver&lung&pbmcHealthy&spleen"=18,
  "kidney&liver&lung&pbmcHealthy&thymus"=16,
  "kidney&liver&lung&spleen&thymus"=30,
  "kidney&liver&pancreas&pbmcHealthy&spleen"=1,
  "kidney&liver&pancreas&pbmcHealthy&thymus"=2,
  "kidney&liver&pancreas&spleen&thymus"=19,
  "kidney&liver&pbmcHealthy&spleen&thymus"=19,
  "kidney&lung&pancreas&spleen&thymus"=16,
  "kidney&lung&pbmcHealthy&spleen&thymus"=15,
  "kidney&pancreas&pbmcHealthy&spleen&thymus"=1,
  "liver&lung&pancreas&pbmcHealthy&spleen"=5,
  "liver&lung&pancreas&spleen&thymus"=17,
  "liver&lung&pbmcHealthy&spleen&thymus"=81,
  "liver&pancreas&pbmcHealthy&spleen&thymus"=2,
  "cerebellum&cerebrum&heart&kidney&liver&lung"=14,
  "cerebellum&cerebrum&heart&kidney&liver&pancreas"=12,
  "cerebellum&cerebrum&heart&kidney&liver&spleen"=10,
  "cerebellum&cerebrum&heart&kidney&liver&thymus"=11,
  "cerebellum&cerebrum&heart&kidney&lung&pancreas"=13,
  "cerebellum&cerebrum&heart&kidney&lung&spleen"=13,
  "cerebellum&cerebrum&heart&kidney&lung&thymus"=13,
  "cerebellum&cerebrum&heart&kidney&pancreas&spleen"=9,
  "cerebellum&cerebrum&heart&kidney&pancreas&thymus"=12,
  "cerebellum&cerebrum&heart&kidney&spleen&thymus"=11,
  "cerebellum&cerebrum&heart&liver&lung&pancreas"=12,
  "cerebellum&cerebrum&heart&liver&lung&spleen"=9,
  "cerebellum&cerebrum&heart&liver&lung&thymus"=11,
  "cerebellum&cerebrum&heart&liver&pancreas&spleen"=8,
  "cerebellum&cerebrum&heart&liver&pancreas&thymus"=11,
  "cerebellum&cerebrum&heart&liver&spleen&thymus"=9,
  "cerebellum&cerebrum&heart&lung&pancreas&spleen"=9,
  "cerebellum&cerebrum&heart&lung&pancreas&thymus"=12,
  "cerebellum&cerebrum&heart&lung&spleen&thymus"=10,
  "cerebellum&cerebrum&heart&pancreas&spleen&thymus"=9,
  "cerebellum&cerebrum&kidney&liver&lung&pancreas"=18,
  "cerebellum&cerebrum&kidney&liver&lung&spleen"=15,
  "cerebellum&cerebrum&kidney&liver&lung&thymus"=17,
  "cerebellum&cerebrum&kidney&liver&pancreas&spleen"=14,
  "cerebellum&cerebrum&kidney&liver&pancreas&thymus"=17,
  "cerebellum&cerebrum&kidney&liver&spleen&thymus"=15,
  "cerebellum&cerebrum&kidney&lung&pancreas&spleen"=15,
  "cerebellum&cerebrum&kidney&lung&pancreas&thymus"=18,
  "cerebellum&cerebrum&kidney&lung&pbmcHealthy&thymus"=9,
  "cerebellum&cerebrum&kidney&lung&spleen&thymus"=16,
  "cerebellum&cerebrum&kidney&pancreas&spleen&thymus"=16,
  "cerebellum&cerebrum&liver&lung&pancreas&spleen"=14,
  "cerebellum&cerebrum&liver&lung&pancreas&thymus"=17,
  "cerebellum&cerebrum&liver&lung&spleen&thymus"=14,
  "cerebellum&cerebrum&liver&pancreas&spleen&thymus"=14,
  "cerebellum&cerebrum&lung&pancreas&spleen&thymus"=15,
  "cerebellum&heart&kidney&liver&lung&pancreas"=12,
  "cerebellum&heart&kidney&liver&lung&spleen"=9,
  "cerebellum&heart&kidney&liver&lung&thymus"=11,
  "cerebellum&heart&kidney&liver&pancreas&spleen"=9,
  "cerebellum&heart&kidney&liver&pancreas&thymus"=12,
  "cerebellum&heart&kidney&liver&spleen&thymus"=11,
  "cerebellum&heart&kidney&lung&pancreas&spleen"=9,
  "cerebellum&heart&kidney&lung&pancreas&thymus"=12,
  "cerebellum&heart&kidney&lung&spleen&thymus"=10,
  "cerebellum&heart&kidney&pancreas&spleen&thymus"=21,
  "cerebellum&heart&liver&lung&pancreas&spleen"=8,
  "cerebellum&heart&liver&lung&pancreas&thymus"=11,
  "cerebellum&heart&liver&lung&spleen&thymus"=8,
  "cerebellum&heart&liver&pancreas&spleen&thymus"=9,
  "cerebellum&heart&lung&pancreas&spleen&thymus"=9,
  "cerebellum&kidney&liver&lung&pancreas&spleen"=14,
  "cerebellum&kidney&liver&lung&pancreas&thymus"=17,
  "cerebellum&kidney&liver&lung&spleen&thymus"=14,
  "cerebellum&kidney&liver&pancreas&pbmcHealthy&thymus"=1,
  "cerebellum&kidney&liver&pancreas&spleen&thymus"=15,
  "cerebellum&kidney&lung&pancreas&spleen&thymus"=15,
  "cerebellum&liver&lung&pancreas&spleen&thymus"=14,
  "cerebrum&heart&kidney&liver&lung&pancreas"=19,
  "cerebrum&heart&kidney&liver&lung&spleen"=16,
  "cerebrum&heart&kidney&liver&lung&thymus"=15,
  "cerebrum&heart&kidney&liver&pancreas&spleen"=12,
  "cerebrum&heart&kidney&liver&pancreas&thymus"=13,
  "cerebrum&heart&kidney&liver&spleen&thymus"=11,
  "cerebrum&heart&kidney&lung&pancreas&spleen"=13,
  "cerebrum&heart&kidney&lung&pancreas&thymus"=15,
  "cerebrum&heart&kidney&lung&spleen&thymus"=12,
  "cerebrum&heart&kidney&pancreas&spleen&thymus"=10,
  "cerebrum&heart&liver&lung&pancreas&spleen"=12,
  "cerebrum&heart&liver&lung&pancreas&thymus"=13,
  "cerebrum&heart&liver&lung&pbmcHealthy&spleen"=19,
  "cerebrum&heart&liver&lung&spleen&thymus"=10,
  "cerebrum&heart&liver&pancreas&spleen&thymus"=9,
  "cerebrum&heart&lung&pancreas&spleen&thymus"=10,
  "cerebrum&kidney&liver&lung&pancreas&spleen"=19,
  "cerebrum&kidney&liver&lung&pancreas&thymus"=19,
  "cerebrum&kidney&liver&lung&spleen&thymus"=16,
  "cerebrum&kidney&liver&pancreas&spleen&thymus"=15,
  "cerebrum&kidney&lung&pancreas&spleen&thymus"=16,
  "cerebrum&liver&lung&pancreas&spleen&thymus"=15,
  "heart&kidney&liver&lung&pancreas&spleen"=12,
  "heart&kidney&liver&lung&pancreas&thymus"=14,
  "heart&kidney&liver&lung&pbmcHealthy&spleen"=18,
  "heart&kidney&liver&lung&pbmcHealthy&thymus"=15,
  "heart&kidney&liver&lung&spleen&thymus"=22,
  "heart&kidney&liver&pancreas&pbmcHealthy&spleen"=1,
  "heart&kidney&liver&pancreas&pbmcHealthy&thymus"=1,
  "heart&kidney&liver&pancreas&spleen&thymus"=11,
  "heart&kidney&liver&pbmcHealthy&spleen&thymus"=19,
  "heart&kidney&lung&pancreas&spleen&thymus"=10,
  "heart&kidney&lung&pbmcHealthy&spleen&thymus"=15,
  "heart&kidney&pancreas&pbmcHealthy&spleen&thymus"=1,
  "heart&liver&lung&pancreas&pbmcHealthy&spleen"=1,
  "heart&liver&lung&pancreas&spleen&thymus"=10,
  "heart&liver&lung&pbmcHealthy&spleen&thymus"=76,
  "heart&liver&pancreas&pbmcHealthy&spleen&thymus"=2,
  "kidney&liver&lung&pancreas&spleen&thymus"=15,
  "kidney&liver&lung&pbmcHealthy&spleen&thymus"=15,
  "kidney&liver&pancreas&pbmcHealthy&spleen&thymus"=1,
  "cerebellum&cerebrum&heart&kidney&liver&lung&pancreas"=12,
  "cerebellum&cerebrum&heart&kidney&liver&lung&spleen"=9,
  "cerebellum&cerebrum&heart&kidney&liver&lung&thymus"=11,
  "cerebellum&cerebrum&heart&kidney&liver&pancreas&spleen"=8,
  "cerebellum&cerebrum&heart&kidney&liver&pancreas&thymus"=11,
  "cerebellum&cerebrum&heart&kidney&liver&spleen&thymus"=9,
  "cerebellum&cerebrum&heart&kidney&lung&pancreas&spleen"=9,
  "cerebellum&cerebrum&heart&kidney&lung&pancreas&thymus"=12,
  "cerebellum&cerebrum&heart&kidney&lung&spleen&thymus"=10,
  "cerebellum&cerebrum&heart&kidney&pancreas&spleen&thymus"=9,
  "cerebellum&cerebrum&heart&liver&lung&pancreas&spleen"=8,
  "cerebellum&cerebrum&heart&liver&lung&pancreas&thymus"=11,
  "cerebellum&cerebrum&heart&liver&lung&spleen&thymus"=8,
  "cerebellum&cerebrum&heart&liver&pancreas&spleen&thymus"=8,
  "cerebellum&cerebrum&heart&lung&pancreas&spleen&thymus"=9,
  "cerebellum&cerebrum&kidney&liver&lung&pancreas&spleen"=14,
  "cerebellum&cerebrum&kidney&liver&lung&pancreas&thymus"=17,
  "cerebellum&cerebrum&kidney&liver&lung&spleen&thymus"=14,
  "cerebellum&cerebrum&kidney&liver&pancreas&spleen&thymus"=14,
  "cerebellum&cerebrum&kidney&lung&pancreas&spleen&thymus"=15,
  "cerebellum&cerebrum&liver&lung&pancreas&spleen&thymus"=14,
  "cerebellum&heart&kidney&liver&lung&pancreas&spleen"=8,
  "cerebellum&heart&kidney&liver&lung&pancreas&thymus"=11,
  "cerebellum&heart&kidney&liver&lung&spleen&thymus"=8,
  "cerebellum&heart&kidney&liver&pancreas&spleen&thymus"=9,
  "cerebellum&heart&kidney&lung&pancreas&spleen&thymus"=9,
  "cerebellum&heart&liver&lung&pancreas&spleen&thymus"=8,
  "cerebellum&kidney&liver&lung&pancreas&spleen&thymus"=14,
  "cerebrum&heart&kidney&liver&lung&pancreas&spleen"=12,
  "cerebrum&heart&kidney&liver&lung&pancreas&thymus"=13,
  "cerebrum&heart&kidney&liver&lung&spleen&thymus"=10,
  "cerebrum&heart&kidney&liver&pancreas&spleen&thymus"=9,
  "cerebrum&heart&kidney&lung&pancreas&spleen&thymus"=10,
  "cerebrum&heart&liver&lung&pancreas&spleen&thymus"=9,
  "cerebrum&kidney&liver&lung&pancreas&spleen&thymus"=15,
  "heart&kidney&liver&lung&pancreas&spleen&thymus"=9,
  "heart&kidney&liver&lung&pbmcHealthy&spleen&thymus"=15,
  "heart&kidney&liver&pancreas&pbmcHealthy&spleen&thymus"=1,
  "cerebellum&cerebrum&heart&kidney&liver&lung&pancreas&spleen"=8,
  "cerebellum&cerebrum&heart&kidney&liver&lung&pancreas&thymus"=11,
  "cerebellum&cerebrum&heart&kidney&liver&lung&spleen&thymus"=8,
  "cerebellum&cerebrum&heart&kidney&liver&pancreas&spleen&thymus"=8,
  "cerebellum&cerebrum&heart&kidney&lung&pancreas&spleen&thymus"=9,
  "cerebellum&cerebrum&heart&liver&lung&pancreas&spleen&thymus"=8,
  "cerebellum&cerebrum&kidney&liver&lung&pancreas&spleen&thymus"=14,
  "cerebellum&heart&kidney&liver&lung&pancreas&spleen&thymus"=8,
  "cerebrum&heart&kidney&liver&lung&pancreas&spleen&thymus"=9,
  "cerebellum&cerebrum&heart&kidney&liver&lung&pancreas&spleen&thymus"=8
)


#upset(fromExpression(expressionInput), nsets=10, nintersects = 60,  order.by = 'freq')

ComplexUpset::upset(UpSetR::fromExpression(expressionInput), c( 'cerebellum',
                                                                'cerebrum',
                                                                'heart',
                                                                'kidney',
                                                                'liver',
                                                                'lung',
                                                                'pancreas',
                                                                'pbmcHealthy',
                                                                'spleen',
                                                                'thymus'), name='Tissue', min_size=80, width_ratio=0.15, set_sizes=upset_set_size(filter_intersections=TRUE))